<?php

/**
 * اسکریپت تست دستورات ربات
 * Bot Commands Test Script
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "🧪 تست دستورات ربات...\n";
echo "=" . str_repeat("=", 50) . "\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    echo "✅ ربات آماده است\n";
    
    // شبیه‌سازی پیام‌های مختلف
    $testMessages = [
        [
            'message' => [
                'message_id' => 1,
                'from' => [
                    'id' => 315447992,
                    'username' => 'Hemn4827',
                    'first_name' => 'Hemn'
                ],
                'chat' => [
                    'id' => 315447992,
                    'type' => 'private'
                ],
                'text' => '/start',
                'date' => time()
            ]
        ],
        [
            'message' => [
                'message_id' => 2,
                'from' => [
                    'id' => 315447992,
                    'username' => 'Hemn4827',
                    'first_name' => 'Hemn'
                ],
                'chat' => [
                    'id' => 315447992,
                    'type' => 'private'
                ],
                'text' => '/help',
                'date' => time()
            ]
        ],
        [
            'message' => [
                'message_id' => 3,
                'from' => [
                    'id' => 315447992,
                    'username' => 'Hemn4827',
                    'first_name' => 'Hemn'
                ],
                'chat' => [
                    'id' => 315447992,
                    'type' => 'private'
                ],
                'text' => '/status',
                'date' => time()
            ]
        ]
    ];
    
    echo "\n📨 شبیه‌سازی دستورات...\n";
    
    foreach ($testMessages as $i => $update) {
        echo "\n" . ($i + 1) . ". تست دستور: " . $update['message']['text'] . "\n";
        
        try {
            $bot->handlePrivateMessage($update['message']);
            echo "   ✅ دستور پردازش شد\n";
        } catch (Exception $e) {
            echo "   ❌ خطا: " . $e->getMessage() . "\n";
        }
        
        sleep(1); // فاصله بین دستورات
    }
    
    echo "\n📊 بررسی آمار ربات...\n";
    $canPost = $bot->canPostNow();
    echo "✅ امکان ارسال پست: " . ($canPost ? "بله" : "خیر") . "\n";
    
    // بررسی پیام‌های جدید از تلگرام
    echo "\n📡 بررسی پیام‌های جدید از تلگرام...\n";
    $updates = $bot->getUpdates();
    echo "✅ " . count($updates) . " پیام جدید دریافت شد\n";
    
    if (!empty($updates)) {
        echo "\n📋 آخرین پیام‌ها:\n";
        foreach (array_slice($updates, -3) as $update) {
            if (isset($update['message'])) {
                $msg = $update['message'];
                $text = $msg['text'] ?? 'بدون متن';
                $from = $msg['from']['username'] ?? $msg['from']['first_name'] ?? 'نامشخص';
                echo "   - از {$from}: {$text}\n";
            }
        }
    }
    
    echo "\n🎉 تست دستورات تکمیل شد!\n";
    
} catch (Exception $e) {
    echo "❌ خطا در تست: " . $e->getMessage() . "\n";
    exit(1);
}
