<?php

/**
 * اسکریپت اجرای Migration
 * Run Database Migration Script
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../database/migrations/2024_01_01_000001_create_main_tables.php';

use PDO;

echo "🚀 شروع اجرای Migration...\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $pdo = new PDO("sqlite:$dbPath");
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✅ اتصال به پایگاه داده برقرار شد\n";
    echo "📁 مسیر پایگاه داده: $dbPath\n";
    
    // اجرای migration
    $migration = new CreateMainTables($pdo);
    $migration->up();
    
    echo "✅ Migration با موفقیت اجرا شد\n";
    
    // بررسی جداول ایجاد شده
    $tables = $pdo->query("SELECT name FROM sqlite_master WHERE type='table'")->fetchAll(PDO::FETCH_COLUMN);
    echo "📊 جداول ایجاد شده:\n";
    foreach ($tables as $table) {
        echo "  - $table\n";
    }
    
    // اضافه کردن کاربر ادمین پیش‌فرض
    $adminUserId = 315447992; // شناسه کاربر از لاگ‌ها
    $stmt = $pdo->prepare("
        INSERT OR IGNORE INTO admin_users (user_id, username, full_name, permissions, is_active) 
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->execute([$adminUserId, 'Hemn4827', 'مدیر سیستم', 'admin', 1]);
    
    echo "✅ کاربر ادمین اضافه شد: $adminUserId\n";
    
    // بررسی آمار اولیه
    $statsStmt = $pdo->query("SELECT * FROM bot_stats WHERE id = 1");
    $stats = $statsStmt->fetch(PDO::FETCH_ASSOC);
    
    if ($stats) {
        echo "✅ آمار اولیه ربات ایجاد شد\n";
    }
    
    echo "\n🎉 Migration با موفقیت تکمیل شد!\n";
    echo "ربات حالا آماده استفاده است.\n";
    
} catch (Exception $e) {
    echo "❌ خطا در اجرای Migration: " . $e->getMessage() . "\n";
    exit(1);
}
