<?php

/**
 * اسکریپت نهایی اجرای ربات
 * Final Bot Runner
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "🤖 ربات خبری پیشرفته\n";
echo "=" . str_repeat("=", 30) . "\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    echo "✅ ربات آماده است\n";
    echo "📱 آماده دریافت دستورات...\n\n";
    
    // ارسال پیام خوش‌آمدگویی
    $adminUserId = 315447992;
    $welcomeMessage = "🤖 ربات آماده است!\n\n";
    $welcomeMessage .= "📋 دستورات موجود:\n";
    $welcomeMessage .= "/start - شروع ربات\n";
    $welcomeMessage .= "/help - راهنما\n";
    $welcomeMessage .= "/status - وضعیت ربات\n";
    $welcomeMessage .= "/news - آخرین اخبار\n\n";
    $welcomeMessage .= "🕐 " . date('Y/m/d H:i:s');
    
    $bot->sendPrivateMessage($adminUserId, $welcomeMessage);
    echo "📤 پیام خوش‌آمدگویی ارسال شد\n\n";
    
    $lastUpdateId = 0;
    
    while (true) {
        try {
            // دریافت پیام‌های جدید
            $updates = $bot->getUpdates();
            
            if (!empty($updates)) {
                foreach ($updates as $update) {
                    if (isset($update['message']) && $update['message']['chat']['type'] === 'private') {
                        $message = $update['message'];
                        $text = $message['text'] ?? '';
                        $from = $message['from']['username'] ?? $message['from']['first_name'] ?? 'نامشخص';
                        
                        echo "📨 {$from}: {$text}\n";
                        
                        // پردازش پیام
                        $bot->handlePrivateMessage($message);
                        
                        echo "✅ پاسخ ارسال شد\n";
                    }
                    
                    $lastUpdateId = $update['update_id'];
                }
            }
            
            sleep(3);
            
        } catch (Exception $e) {
            echo "❌ خطا: " . $e->getMessage() . "\n";
            sleep(5);
        }
    }
    
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage() . "\n";
    exit(1);
}
