<?php

/**
 * اسکریپت حذف Webhook
 * Delete Webhook Script
 */

// بارگذاری autoloader
require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Services/TranslationService.php';
require_once __DIR__ . '/../src/Services/NewsFetcher.php';
require_once __DIR__ . '/../src/Services/TelegramBot.php';

echo "🔧 حذف Webhook...\n";

try {
    // اتصال به پایگاه داده
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    // ایجاد ربات
    $botToken = Config::get('bot.token');
    $channelId = Config::get('bot.channel_id');
    
    $bot = new TelegramBot($botToken, $channelId, $db);
    
    // حذف webhook
    $success = $bot->deleteWebhook();
    
    if ($success) {
        echo "✅ Webhook با موفقیت حذف شد\n";
    } else {
        echo "❌ خطا در حذف Webhook\n";
    }
    
    echo "✅ ربات حالا آماده دریافت پیام‌های خصوصی است\n";
    
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage() . "\n";
}
