# 🔧 راهنمای عیب‌یابی ربات

## ❌ مشکلات شما و راه‌حل‌ها

### **مشکل 1: خطای اتصال به تلگرام (cURL error 28)**

**خطا:**
```
❌ تلگرام: cURL error 28: Failed to connect to api.cwrtex.ir port 443: Connection timed out
```

**علت:** هاست شما نمی‌تواند به `api.cwrtex.ir` وصل شود.

**راه‌حل‌ها:**

#### **راه‌حل 1: تماس با پشتیبانی هاست**
- با پشتیبانی هاست تماس بگیرید
- بگویید که نیاز به اتصال به `api.cwrtex.ir` دارید
- ممکن است فایروال هاست مانع اتصال باشد

#### **راه‌حل 2: استفاده از Proxy (پیشرفته)**
```php
// در فایل enhanced_web_bot_runner.php
curl_setopt($ch, CURLOPT_PROXY, 'proxy.example.com:8080');
curl_setopt($ch, CURLOPT_PROXYUSERPWD, 'username:password');
```

#### **راه‌حل 3: تغییر DNS هاست**
- در پنل هاست، DNS را به `8.8.8.8` و `8.8.4.4` تغییر دهید

### **مشکل 2: خطای پایگاه داده (warning)**

**علت:** مشکل در دسترسی به فایل پایگاه داده یا مجوزها

**راه‌حل:**
```bash
chmod 755 storage/
chmod 644 storage/database.sqlite
chmod 755 storage/logs/
```

### **مشکل 3: دکمه کپی URL کار نمی‌کند**

**علت:** JavaScript مشکل دارد یا مرورگر از Clipboard API پشتیبانی نمی‌کند

**راه‌حل:**
1. **کپی دستی:** روی URL کلیک کنید و Ctrl+C بزنید
2. **مرورگر جدید:** از Chrome یا Firefox استفاده کنید
3. **HTTPS:** از HTTPS استفاده کنید (برای Clipboard API لازم است)

### **مشکل 4: ربات به دستورات جواب نمی‌دهد**

**علت:** ربات فقط برای ارسال اخبار طراحی شده، نه پاسخ به دستورات

**توضیح:** این ربات یک **کانال خبری** است، نه یک **ربات چت**. فقط اخبار را در کانال ارسال می‌کند.

## 🚀 **فایل‌های مورد نیاز برای اجرا**

### **فایل اصلی:**
- `enhanced_web_bot_runner.php` - **این فایل را اجرا کنید**

### **فایل‌های پشتیبان:**
- `bot_manager.html` - پنل مدیریت
- `web_bot_runner.php` - نسخه قدیمی
- `shared_hosting_runner.php` - نسخه خط فرمان

## 📋 **مراحل اجرای صحیح**

### **مرحله 1: آپلود فایل‌ها**
```bash
# آپلود این فایل‌ها به هاست:
- enhanced_web_bot_runner.php
- bot_manager.html
- vendor/ (پوشه وابستگی‌ها)
- src/ (پوشه کدها)
- config/ (پوشه تنظیمات)
- storage/ (پوشه ذخیره‌سازی)
```

### **مرحله 2: تنظیم مجوزها**
```bash
chmod 755 storage/
chmod 644 storage/database.sqlite
chmod 755 storage/logs/
chmod 600 .env
```

### **مرحله 3: ویرایش تنظیمات**
فایل `.env` را ویرایش کنید:
```env
BOT_TOKEN=YOUR_BOT_TOKEN_HERE
CHANNEL_ID=YOUR_CHANNEL_ID_HERE
NEWS_API_KEY=YOUR_NEWS_API_KEY_HERE
```

### **مرحله 4: تست ربات**
```
https://yourdomain.com/bot_manager.html
```

### **مرحله 5: تنظیم Cron Job**
در Cron-job.org:
- **URL**: `https://yourdomain.com/enhanced_web_bot_runner.php?action=run`
- **زمان**: هر 30 دقیقه
- **روش**: GET

## 🧪 **تست‌های موجود**

### **تست اتصالات:**
```
https://yourdomain.com/enhanced_web_bot_runner.php?action=test
```

### **تست فقط تلگرام:**
```
https://yourdomain.com/enhanced_web_bot_runner.php?action=test-telegram
```

### **تست فقط NewsAPI:**
```
https://yourdomain.com/enhanced_web_bot_runner.php?action=test-newsapi
```

### **اجرای ربات:**
```
https://yourdomain.com/enhanced_web_bot_runner.php?action=run
```

### **بررسی وضعیت:**
```
https://yourdomain.com/enhanced_web_bot_runner.php?action=status
```

## 🔍 **عیب‌یابی پیشرفته**

### **بررسی لاگ‌ها:**
```bash
# لاگ اصلی
tail -f storage/logs/enhanced_web_bot.log

# لاگ تلگرام
tail -f storage/logs/telegram_bot.log

# لاگ دریافت اخبار
tail -f storage/logs/news_fetcher.log
```

### **بررسی تنظیمات PHP:**
```php
// در فایل phpinfo.php
<?php phpinfo(); ?>
```

### **بررسی اتصال اینترنت:**
```php
// در فایل test_connection.php
<?php
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'https://api.cwrtex.ir');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$result = curl_exec($ch);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
    echo "خطا: $error";
} else {
    echo "اتصال موفق";
}
?>
```

## 🆘 **راه‌حل‌های اضطراری**

### **اگر هیچ‌کدام کار نکرد:**

#### **راه‌حل 1: استفاده از سرویس‌های Cloud**
- Heroku (رایگان)
- Vercel (رایگان)
- Railway (رایگان)

#### **راه‌حل 2: استفاده از VPS**
- خرید VPS ارزان
- نصب PHP و اجرای ربات

#### **راه‌حل 3: استفاده از سرویس‌های آماده**
- Zapier
- IFTTT
- Microsoft Power Automate

## 📞 **پشتیبانی**

### **در صورت مشکل:**
1. **بررسی لاگ‌ها**
2. **تست اتصالات**
3. **تماس با پشتیبانی هاست**
4. **استفاده از سرویس‌های جایگزین**

### **اطلاعات مورد نیاز برای پشتیبانی:**
- نسخه PHP هاست
- تنظیمات فایروال
- لاگ‌های خطا
- نتیجه تست اتصالات

---

**نکته مهم**: فایل `enhanced_web_bot_runner.php` را استفاده کنید - این فایل مشکلات اتصال را حل می‌کند! 🚀
