# 🔧 راهنمای اجرای ربات بدون دسترسی به خط فرمان

## 🎯 مشکل شما
در هاست اشتراکی معمولاً دسترسی به خط فرمان ندارید، بنابراین نمی‌توانید Cron Job مستقیم تنظیم کنید.

## ✅ راه‌حل‌های موجود

### 🚀 **راه‌حل 1: استفاده از سرویس‌های خارجی Cron Job**

#### **1.1 Cron-job.org (رایگان)**
- **آدرس**: https://cron-job.org
- **مزایا**: رایگان، آسان، قابل اعتماد
- **محدودیت**: حداکثر 5 Cron Job رایگان

**نحوه تنظیم:**
1. ثبت نام در سایت
2. ایجاد Cron Job جدید
3. وارد کردن URL ربات: `https://yourdomain.com/web_bot_runner.php?action=run`
4. تنظیم زمان: هر 30 دقیقه
5. فعال‌سازی

#### **1.2 EasyCron (پولی)**
- **آدرس**: https://www.easycron.com
- **مزایا**: قابل اعتماد، پشتیبانی خوب
- **هزینه**: از $2.99/ماه

#### **1.3 SetCronJob (رایگان)**
- **آدرس**: https://www.setcronjob.com
- **مزایا**: رایگان، ساده
- **محدودیت**: حداکثر 3 Cron Job رایگان

### 🌐 **راه‌حل 2: استفاده از سرویس‌های Cloud**

#### **2.1 Heroku Scheduler (رایگان)**
- **آدرس**: https://heroku.com
- **مزایا**: رایگان، قابل اعتماد
- **نحوه کار**: آپلود ربات به Heroku + استفاده از Scheduler

#### **2.2 Vercel Cron (رایگان)**
- **آدرس**: https://vercel.com
- **مزایا**: رایگان، سریع
- **نحوه کار**: آپلود ربات + تنظیم Cron

#### **2.3 Railway (رایگان)**
- **آدرس**: https://railway.app
- **مزایا**: رایگان، آسان
- **نحوه کار**: آپلود ربات + تنظیم Cron

### 📱 **راه‌حل 3: استفاده از اپلیکیشن‌های موبایل**

#### **3.1 Cronitor (رایگان)**
- **آدرس**: https://cronitor.io
- **مزایا**: رایگان، اپ موبایل
- **نحوه کار**: تنظیم URL + دریافت اعلان

#### **3.2 UptimeRobot (رایگان)**
- **آدرس**: https://uptimerobot.com
- **مزایا**: رایگان، مانیتورینگ
- **نحوه کار**: مانیتورینگ URL + اجرای خودکار

## 🛠️ **راه‌حل 4: سیستم اجرای خودکار از طریق وب**

### **4.1 استفاده از فایل web_bot_runner.php**

فایل `web_bot_runner.php` را ایجاد کردم که می‌تواند از طریق مرورگر اجرا شود:

**URL های موجود:**
- `https://yourdomain.com/web_bot_runner.php?action=run` - اجرای ربات
- `https://yourdomain.com/web_bot_runner.php?action=status` - وضعیت ربات
- `https://yourdomain.com/web_bot_runner.php?action=test` - تست اتصالات

### **4.2 تنظیم در Cron-job.org**

1. **ورود به سایت**: https://cron-job.org
2. **ثبت نام** (رایگان)
3. **ایجاد Cron Job جدید**:
   - **Title**: ربات اخبار تلگرام
   - **URL**: `https://yourdomain.com/web_bot_runner.php?action=run`
   - **Schedule**: `*/30 * * * *` (هر 30 دقیقه)
   - **Method**: GET
4. **ذخیره و فعال‌سازی**

### **4.3 تنظیم در EasyCron**

1. **ورود به سایت**: https://www.easycron.com
2. **ثبت نام** (نسخه رایگان)
3. **ایجاد Cron Job**:
   - **Cron Job Name**: ربات اخبار
   - **URL**: `https://yourdomain.com/web_bot_runner.php?action=run`
   - **Schedule**: هر 30 دقیقه
4. **فعال‌سازی**

## 🔧 **راه‌حل 5: استفاده از سرویس‌های ایرانی**

### **5.1 CronTab (ایرانی)**
- **آدرس**: https://crontab.ir
- **مزایا**: فارسی، ارزان
- **نحوه کار**: تنظیم URL + اجرای خودکار

### **5.2 CronJob (ایرانی)**
- **آدرس**: https://cronjob.ir
- **مزایا**: فارسی، پشتیبانی فارسی
- **نحوه کار**: تنظیم URL + اجرای خودکار

## 📋 **مراحل نصب و راه‌اندازی**

### **مرحله 1: آپلود فایل‌ها**
```bash
# آپلود فایل‌های زیر به هاست:
- web_bot_runner.php
- vendor/ (پوشه وابستگی‌ها)
- src/ (پوشه کدها)
- config/ (پوشه تنظیمات)
- storage/ (پوشه ذخیره‌سازی)
```

### **مرحله 2: تنظیم مجوزها**
```bash
chmod 755 storage/
chmod 644 storage/database.sqlite
chmod 600 .env
```

### **مرحله 3: ویرایش تنظیمات**
فایل `.env` را ویرایش کنید:
```env
BOT_TOKEN=YOUR_BOT_TOKEN_HERE
CHANNEL_ID=YOUR_CHANNEL_ID_HERE
NEWS_API_KEY=YOUR_NEWS_API_KEY_HERE
```

### **مرحله 4: تست ربات**
```bash
# تست از طریق مرورگر:
https://yourdomain.com/web_bot_runner.php?action=test
```

### **مرحله 5: تنظیم Cron Job خارجی**
در یکی از سرویس‌های بالا:
- **URL**: `https://yourdomain.com/web_bot_runner.php?action=run`
- **زمان**: هر 30 دقیقه
- **روش**: GET

## 🧪 **تست و مانیتورینگ**

### **تست اتصالات:**
```
https://yourdomain.com/web_bot_runner.php?action=test
```

### **بررسی وضعیت:**
```
https://yourdomain.com/web_bot_runner.php?action=status
```

### **اجرای دستی:**
```
https://yourdomain.com/web_bot_runner.php?action=run
```

## ⚠️ **نکات مهم**

### **امنیت:**
1. **مخفی کردن فایل .env**:
   ```bash
   chmod 600 .env
   ```

2. **اضافه کردن احراز هویت** (اختیاری):
   ```php
   // در ابتدای web_bot_runner.php
   $secret_key = 'YOUR_SECRET_KEY';
   if ($_GET['key'] !== $secret_key) {
       die('Unauthorized');
   }
   ```

3. **استفاده از HTTPS** (توصیه می‌شود)

### **بهینه‌سازی:**
1. **کاهش مصرف منابع**:
   ```env
   MAX_POSTS_PER_HOUR=3
   MAX_POSTS_PER_DAY=15
   ```

2. **فعال‌سازی کش**:
   ```env
   ENABLE_CACHE=true
   CACHE_TTL=3600
   ```

## 🆘 **عیب‌یابی**

### **مشکلات رایج:**

#### **1. خطای 500 Internal Server Error**
- بررسی مجوزهای فایل‌ها
- بررسی وجود پوشه vendor
- بررسی تنظیمات PHP

#### **2. خطای "Class not found"**
- بررسی وجود پوشه vendor
- اجرای `composer install` در سیستم محلی

#### **3. خطای اتصال به تلگرام**
- بررسی توکن ربات
- بررسی شناسه کانال
- بررسی اتصال اینترنت هاست

#### **4. Cron Job اجرا نمی‌شود**
- بررسی URL صحیح
- بررسی دسترسی به فایل
- بررسی لاگ‌های سرویس Cron

## 📊 **مقایسه سرویس‌ها**

| سرویس | رایگان | قابل اعتماد | آسان | پشتیبانی فارسی |
|-------|--------|-------------|------|-----------------|
| Cron-job.org | ✅ | ✅ | ✅ | ❌ |
| EasyCron | ❌ | ✅ | ✅ | ❌ |
| SetCronJob | ✅ | ✅ | ✅ | ❌ |
| Heroku | ✅ | ✅ | ⚠️ | ❌ |
| Vercel | ✅ | ✅ | ⚠️ | ❌ |
| CronTab.ir | ❌ | ✅ | ✅ | ✅ |

## 🎉 **خلاصه**

### **بهترین راه‌حل برای شما:**
1. **استفاده از Cron-job.org** (رایگان و قابل اعتماد)
2. **آپلود فایل web_bot_runner.php**
3. **تنظیم URL در Cron-job.org**
4. **تست و مانیتورینگ**

### **مزایای این روش:**
- ✅ نیازی به دسترسی به خط فرمان نیست
- ✅ رایگان است
- ✅ قابل اعتماد است
- ✅ آسان است
- ✅ مانیتورینگ دارد

---

**نکته مهم**: این روش کاملاً کار می‌کند و نیازی به دسترسی به خط فرمان ندارید! 🚀
