<?php

/**
 * اسکریپت پاک‌سازی داده‌های قدیمی
 * Cleanup Script for Old Data
 */

require_once __DIR__ . '/../vendor/autoload.php';
require_once __DIR__ . '/../src/Config.php';
require_once __DIR__ . '/../src/DatabaseManager.php';
require_once __DIR__ . '/../src/Models/Article.php';

echo "🧹 پاک‌سازی داده‌های قدیمی\n";
echo "=" . str_repeat("=", 40) . "\n";

try {
    $dbPath = Config::get('database.path', __DIR__ . '/../storage/database.sqlite');
    $db = new DatabaseManager($dbPath);
    
    $daysOld = $argv[1] ?? 30; // روزهای قدیمی (پیش‌فرض: 30 روز)
    
    echo "📅 حذف داده‌های قدیمی‌تر از $daysOld روز...\n";
    
    // پاک‌سازی مقالات قدیمی
    $articleModel = new Article($db->getConnection());
    $deletedArticles = $articleModel->cleanup($daysOld);
    echo "📰 $deletedArticles مقاله قدیمی حذف شد\n";
    
    // پاک‌سازی ترجمه‌های قدیمی
    $cutoffDate = date('Y-m-d H:i:s', strtotime("-$daysOld days"));
    $sql = "DELETE FROM translations WHERE created_at < :cutoff_date";
    $stmt = $db->query($sql, ['cutoff_date' => $cutoffDate]);
    $deletedTranslations = $stmt->rowCount();
    echo "🌐 $deletedTranslations ترجمه قدیمی حذف شد\n";
    
    // پاک‌سازی لاگ‌های قدیمی
    $sql = "DELETE FROM logs WHERE created_at < :cutoff_date";
    $stmt = $db->query($sql, ['cutoff_date' => $cutoffDate]);
    $deletedLogs = $stmt->rowCount();
    echo "📝 $deletedLogs لاگ قدیمی حذف شد\n";
    
    // پاک‌سازی اعلان‌های قدیمی
    $sql = "DELETE FROM notifications WHERE created_at < :cutoff_date AND is_read = 1";
    $stmt = $db->query($sql, ['cutoff_date' => $cutoffDate]);
    $deletedNotifications = $stmt->rowCount();
    echo "🔔 $deletedNotifications اعلان قدیمی حذف شد\n";
    
    $totalDeleted = $deletedArticles + $deletedTranslations + $deletedLogs + $deletedNotifications;
    echo "\n✅ پاک‌سازی کامل شد: $totalDeleted رکورد حذف شد\n";
    
    // بهینه‌سازی پایگاه داده
    echo "⚡ بهینه‌سازی پایگاه داده...\n";
    if ($db->optimize()) {
        echo "✅ بهینه‌سازی انجام شد\n";
    }
    
    // نمایش آمار نهایی
    $stats = $db->getStats();
    echo "\n📊 آمار نهایی:\n";
    echo "   📰 مقالات: " . $stats['articles_count'] . "\n";
    echo "   👥 کاربران ادمین: " . $stats['admin_users_count'] . "\n";
    echo "   📁 اندازه فایل: " . number_format($stats['file_size'] / 1024, 2) . " KB\n";
    
} catch (Exception $e) {
    echo "❌ خطا: " . $e->getMessage() . "\n";
    exit(1);
}
