<?php

/**
 * تنظیمات اصلی برنامه
 * Advanced Telegram News Bot - Configuration
 */

// بارگذاری کلاس Config
if (!class_exists('Config')) {
    require_once __DIR__ . '/../src/Config.php';
}

return [
    // تنظیمات اصلی ربات
    'bot' => [
        'token' => '7609580116:AAGdJ0wEvtwrX8DlYOCZulOqZhbI3_2fjxw',
        'channel_id' => '-1003190698999',
        'webhook_url' => Config::env('WEBHOOK_URL', ''),
        'admin_users' => explode(',', Config::env('ADMIN_USERS', '')),
    ],

    // تنظیمات API های خارجی
    'apis' => [
        'news_api' => [
            'key' => Config::env('NEWS_API_KEY', 'c4038e45e2c94083b984c9a8907da9bb'),
            'base_url' => 'https://newsapi.org/v2',
            'rate_limit' => 1000, // درخواست در روز
        ],
        'translation' => [
            'service' => Config::env('TRANSLATION_SERVICE', 'mymemory'), // mymemory, libretranslate, google
            'libretranslate_url' => Config::env('LIBRETRANSLATE_URL', 'https://translate.argosopentech.com/translate'),
            'google_api_key' => Config::env('GOOGLE_TRANSLATE_KEY', ''),
        ],
    ],

    // تنظیمات پایگاه داده
    'database' => [
        'driver' => 'sqlite',
        'path' => __DIR__ . '/../storage/database.sqlite',
        'backup_enabled' => true,
        'backup_interval' => 24, // ساعت
    ],

    // تنظیمات زمان‌بندی
    'scheduler' => [
        'news_check_interval' => Config::env('NEWS_CHECK_INTERVAL', 30), // دقیقه
        'cleanup_interval' => Config::env('CLEANUP_INTERVAL', 24), // ساعت
        'stats_reset_hour' => Config::env('STATS_RESET_HOUR', 0), // ساعت شب
    ],

    // محدودیت‌های ارسال
    'rate_limits' => [
        'max_posts_per_hour' => Config::env('MAX_POSTS_PER_HOUR', 10),
        'max_posts_per_day' => Config::env('MAX_POSTS_PER_DAY', 50),
        'min_news_interval' => Config::env('MIN_NEWS_INTERVAL', 5), // دقیقه
        'max_concurrent_requests' => Config::env('MAX_CONCURRENT_REQUESTS', 5),
    ],

    // منابع خبری
    'news_sources' => [
        'english' => [
            'bbc-news', 'cnn', 'the-guardian', 'al-jazeera-english',
            'reuters', 'independent', 'metro', 'mirror', 'bloomberg',
            'financial-times', 'wall-street-journal', 'marketwatch'
        ],
        'persian' => [
            'https://www.tasnimnews.com/fa/rss/feed/0/8/0/%D8%A7%D9%82%D8%AA%D8%B5%D8%A7%D8%AF',
            'https://www.mehrnews.com/rss',
            'https://www.isna.ir/rss',
            'https://www.farsnews.ir/rss',
            'https://www.irna.ir/rss'
        ],
        'crypto' => [
            'https://cointelegraph.com/rss',
            'https://coindesk.com/arc/outboundfeeds/rss/',
            'https://bitcoinmagazine.com/rss',
            'https://decrypt.co/feed'
        ],
        'forex' => [
            'https://www.forexfactory.com/rss.php',
            'https://www.dailyfx.com/feeds/market-news',
            'https://www.fxstreet.com/rss'
        ]
    ],

    // کلمات کلیدی مهم
    'keywords' => [
        'crypto' => [
            'bitcoin', 'crypto', 'cryptocurrency', 'btc', 'eth', 'ethereum',
            'blockchain', 'defi', 'nft', 'altcoin', 'mining', 'wallet',
            'binance', 'coinbase', 'crypto market', 'digital currency'
        ],
        'forex' => [
            'forex', 'trading', 'fx', 'currency', 'exchange rate', 'usd',
            'eur', 'gbp', 'jpy', 'aud', 'cad', 'chf', 'nzd', 'pips',
            'spread', 'leverage', 'margin', 'forex market'
        ],
        'economy' => [
            'economy', 'inflation', 'fed', 'federal reserve', 'interest rate',
            'gdp', 'unemployment', 'stock market', 'nasdaq', 'dow jones',
            's&p 500', 'recession', 'economic growth', 'monetary policy'
        ],
        'iran' => [
            'iran', 'iranian', 'persian', 'tehran', 'oil', 'sanctions',
            'nuclear', 'middle east', 'persian gulf', 'iran economy',
            'iran politics', 'iran news'
        ],
        'politics' => [
            'politics', 'election', 'government', 'policy', 'president',
            'parliament', 'congress', 'senate', 'democracy', 'republic',
            'political party', 'campaign', 'vote'
        ],
        'technology' => [
            'technology', 'ai', 'artificial intelligence', 'tech', 'innovation',
            'startup', 'software', 'hardware', 'internet', 'digital',
            'cybersecurity', 'data', 'cloud computing'
        ]
    ],

    // تنظیمات لاگ
    'logging' => [
        'level' => Config::env('LOG_LEVEL', 'info'),
        'path' => __DIR__ . '/../storage/logs',
        'max_files' => 30,
        'max_size' => '10MB',
    ],

    // تنظیمات کش
    'cache' => [
        'driver' => 'file',
        'path' => __DIR__ . '/../storage/cache',
        'ttl' => 3600, // ثانیه
        'prefix' => 'news_bot_',
    ],

    // تنظیمات امنیتی
    'security' => [
        'encryption_key' => Config::env('ENCRYPTION_KEY', ''),
        'session_timeout' => 3600, // ثانیه
        'max_login_attempts' => 5,
        'lockout_duration' => 900, // ثانیه
    ],

    // تنظیمات پنل مدیریت
    'admin' => [
        'theme' => 'dark',
        'items_per_page' => 20,
        'auto_refresh_interval' => 30, // ثانیه
        'enable_real_time_stats' => true,
    ],

    // تنظیمات اعلان‌ها
    'notifications' => [
        'email' => [
            'enabled' => Config::env('EMAIL_NOTIFICATIONS', false),
            'smtp_host' => Config::env('SMTP_HOST', ''),
            'smtp_port' => Config::env('SMTP_PORT', 587),
            'smtp_username' => Config::env('SMTP_USERNAME', ''),
            'smtp_password' => Config::env('SMTP_PASSWORD', ''),
            'from_email' => Config::env('FROM_EMAIL', ''),
        ],
        'telegram' => [
            'enabled' => Config::env('TELEGRAM_NOTIFICATIONS', true),
            'admin_chat_id' => Config::env('ADMIN_CHAT_ID', ''),
        ]
    ],

    // تنظیمات پشتیبان‌گیری
    'backup' => [
        'enabled' => Config::env('BACKUP_ENABLED', true),
        'interval' => Config::env('BACKUP_INTERVAL', 24), // ساعت
        'retention_days' => Config::env('BACKUP_RETENTION', 30),
        'path' => __DIR__ . '/../storage/backups',
    ],

    // تنظیمات مانیتورینگ
    'monitoring' => [
        'enabled' => Config::env('MONITORING_ENABLED', true),
        'health_check_interval' => 300, // ثانیه
        'alert_thresholds' => [
            'error_rate' => 10, // درصد
            'response_time' => 5000, // میلی‌ثانیه
            'memory_usage' => 80, // درصد
        ]
    ]
];
